/*
 * Decompiled with CFR 0.152.
 */
package me.wesley1808.servercore.mixin.features.misc;

import java.util.BitSet;
import me.wesley1808.servercore.common.config.tables.FeatureConfig;
import me.wesley1808.servercore.common.utils.ChunkManager;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundLevelChunkWithLightPacket;
import net.minecraft.network.protocol.game.ClientboundLightUpdatePacket;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.ThreadedLevelLightEngine;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.lighting.LevelLightEngine;
import org.apache.commons.lang3.mutable.MutableObject;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ChunkMap.class})
public class ChunkMapMixin {
    @Shadow
    @Final
    private ThreadedLevelLightEngine f_140134_;
    @Shadow
    @Final
    public ServerLevel f_140133_;
    @Shadow
    int f_140126_;

    @Inject(method={"playerLoadedChunk"}, at={@At(value="INVOKE", target="Lorg/apache/commons/lang3/mutable/MutableObject;setValue(Ljava/lang/Object;)V", ordinal=0)})
    private void servercore$preventClientLag(ServerPlayer player, MutableObject<ClientboundLevelChunkWithLightPacket> packet, LevelChunk chunk, CallbackInfo ci) {
        if (!FeatureConfig.FIX_CLIENT_LAG_ON_CHUNKBORDERS.get().booleanValue()) {
            return;
        }
        int chunkX = chunk.m_7697_().f_45578_;
        int chunkZ = chunk.m_7697_().f_45579_;
        int playerChunkX = player.m_146902_().f_45578_;
        int playerChunkZ = player.m_146902_().f_45579_;
        BitSet lightMask = this.lightMask((ChunkAccess)chunk);
        if (!lightMask.isEmpty()) {
            for (int x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    ChunkAccess neighbor;
                    int distZ;
                    if (x == 0 && z == 0) continue;
                    int neighborChunkX = chunkX + x;
                    int neighborChunkZ = chunkZ + z;
                    int distX = Math.abs(playerChunkX - neighborChunkX);
                    if (Math.max(distX, distZ = Math.abs(playerChunkZ - neighborChunkZ)) > this.f_140126_ - 1 || (neighbor = ChunkManager.getChunkNow((LevelReader)this.f_140133_, neighborChunkX, neighborChunkZ)) == null) continue;
                    BitSet updateLightMask = (BitSet)lightMask.clone();
                    updateLightMask.andNot(this.ceilingLightMask(neighbor));
                    if (updateLightMask.isEmpty()) continue;
                    player.f_8906_.m_9829_((Packet)new ClientboundLightUpdatePacket(new ChunkPos(neighborChunkX, neighborChunkZ), (LevelLightEngine)this.f_140134_, updateLightMask, null, true));
                }
            }
        }
    }

    @Unique
    private BitSet lightMask(ChunkAccess chunk) {
        LevelChunkSection[] sections = chunk.m_7103_();
        BitSet mask = new BitSet(this.f_140134_.m_164446_());
        for (int i = 0; i < sections.length; ++i) {
            if (sections[i].m_188008_()) continue;
            mask.set(i);
            mask.set(i + 1);
            mask.set(i + 2);
            ++i;
        }
        return mask;
    }

    @Unique
    private BitSet ceilingLightMask(ChunkAccess chunk) {
        LevelChunkSection[] sections = chunk.m_7103_();
        for (int i = sections.length - 1; i >= 0; --i) {
            if (sections[i].m_188008_()) continue;
            int highest = i + 3;
            BitSet mask = new BitSet(highest);
            mask.set(0, highest);
            return mask;
        }
        return new BitSet();
    }
}

